REBOL [
    title: "ImmobilierNet Module agence - edition des nomenclatures"
    version: 1.0
    author: "Olivier Auverlot"
]

nomenclatures: make object! [
    
    ; remise  jour de la liste des intituls
    faire-requete-select: does [
        clear intitules/lines: copy []
        intitules/user-data: copy []
        envoi-sql (join "SELECT * FROM " table)

        foreach ligne buffer [ 
            append intitules/lines (trim ligne/2)
            append intitules/user-data ligne/1
        ]   
        fix-slider intitules
        show intitules
        saisie/text: copy ""
        show saisie
    ]
    
    edition-nomenclature: layout [
        backtile 192.192.192
        across
        intitules: text-list 200x150  [
            num: pick intitules/user-data face/cnt
            saisie/text: copy first intitules/picked
            show saisie
        ] data donnees
        panel 130x150 [
            below
            button "Ajouter" [
                if (length? saisie/text) > 0 [
                    envoi-sql join "INSERT INTO " [ 
                        table " (intitule) values ('" 
                        trim (saisie/text)
                        "')" 
                    ]
                    faire-requete-select
                ]               
            ]
            button "Modifier" [
                if (length? saisie/text) > 0 [
                    envoi-sql join "UPDATE " [ 
                        table " SET intitule='" (trim saisie/text)
                        "' WHERE num=" num
                    ]
                    faire-requete-select
                ]
            ]
            button "Supprimer" [
                if (length? saisie/text) > 0 [
                    either envoi-sql join "DELETE FROM " [
                        table " WHERE num=" num 
                    ] [                        
                        faire-requete-select
                    ] [ request/ok "Une erreur a t dtecte" ]
                ]
            ]
        ]
        return
        saisie: field 200 ""
        return
        button "Fermer" [ unview edition-nomenclature ]    
    ]

    start: function [ n ] [] [ 
        table: pick [
            "chauffages" "etats" "murs"
            "styles" "zonesgeo" "toitures"
        ] n
        faire-requete-select
        view/new edition-nomenclature         
    ]
]